<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model 
{

    protected $table = 'menus';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('menu_no', 'level_no', 'level_status', 'name_ar', 'name_en', 'desc_ar', 'desc_en', 'actions', 'route_name', 'parent_id', 'menu_section_id');

    public function parent()
    {
        return $this->belongsTo('App\Models\Menu', 'parent_id');
    }

    public function companies()
    {
        return $this->belongsToMany('App\Models\MainCompany');
    }

}